# import des different composants necessaires
from vtk import *

# ------------------------------------------------
# creation de structure de donnee,i.e la grille
# ------------------------------------------------

vol = vtkImageData()
vol.SetDimensions(26, 26, 26) 
vol.SetOrigin(-0.5, -0.5, -0.5)
gridStep = 1.0/25.0
vol.SetSpacing(gridStep, gridStep, gridStep)

# creation des donnees, i.e un tableau de flottants
scalarData = vtkFloatArray()

for k in range(26):
    z = -0.5 + k*gridStep
    kOffset = k * 26 *26
    for j in range(26):
        y = -0.5 + j*gridStep
        jOffset = j * 26
        for i in range(26):
            x = -0.5 + i*gridStep
            value = x*x + y*y + z*z - (0.4*0.4)
            offset = i + jOffset + kOffset
            # ajout de la donnee au vtkFloatArray
            scalarData.InsertTuple1(offset, value)

vol.GetPointData().SetScalars(scalarData)

# ------------------------------------------------
# fin de la creation de structure de donnee
# ------------------------------------------------

dataset = vol

# ------------------------------------------------
# creation du pipeline de visualisation par defaut
# ------------------------------------------------
    
mapper = vtkDataSetMapper()
mapper.SetInput(dataset)
    
actor = vtkActor()
actor.SetMapper(mapper)
    
#  ------------------------------------------------
# Fin de la definition du pipeline
#  ------------------------------------------------

#  ------------------------------------------------
# Creation d'une lookuptable et connection au mapper
#  ------------------------------------------------
lookupTable = vtkLookupTable()
lookupTable.SetHueRange(0.66667, 0)
#lookupTable.SetScalarRange(dataset.GetScalarRange())
lookupTable.Build()

# connection de la lookuptable avec le mapper
mapper.SetLookupTable(lookupTable)
mapper.SetScalarRange(dataset.GetScalarRange())

# Definition de la bar de couleur
scalBar = vtkScalarBarActor()
scalBar.SetLookupTable(lookupTable)

#  ------------------------------------------------
# Fin de la creation d'une lookuptable
#  ------------------------------------------------

#  ------------------------------------------------
# Integration de l'acteur dans la vue 3D
#  ------------------------------------------------
    
try:
    cassandra.getPipeLineManager().addDataSet( dataset,"Data")
    cassandra.getPipeLineManager().addMapper(mapper, "")
    actorCassandra = cassandra.getPipeLineManager().addActor(actor, "DataView")
    cassandra.getPipeLineManager().setActorVisible(actorCassandra,1)

    # Ajout de la bar de couleur a la vue
    actorCassandra = cassandra.getPipeLineManager().addScalarBar(scalarBar, "Bar")
    cassandra.getPipeLineManager().setActorVisible(actorCassandra,1)
    cassandra.getPipeLineManager().validateViewAndWait()
        
except:
    # Create the usual rendering stuff
    renderer = vtkRenderer()
    renWin = vtkRenderWindow()
    renWin.AddRenderer(renderer)
    
    iren = vtkRenderWindowInteractor()
    iren.SetRenderWindow(renWin)
    
    renderer.AddActor(actor)

    # Ajoute la bar de couleur
    renderer.AddActor2D(scalBar)
    
    renderer.SetBackground(1,1,1)
    renderer.ResetCamera()
    
    renderer.GetActiveCamera().Elevation(60.0)
    renderer.GetActiveCamera().Azimuth(30.0)
    renderer.GetActiveCamera().Zoom(1.25)
    renWin.SetSize(300,300)
    
    # interact with data
    renWin.Render()
    iren.Start()
    
